#include "SnakeGrid.h"

ASnakeGrid::ASnakeGrid()
{
    // Deaktiviert Tick für bessere Performance, da das Grid statisch ist
    PrimaryActorTick.bCanEverTick = false;
}

void ASnakeGrid::BeginPlay()
{
    Super::BeginPlay();
    SpawnFood(); // Erstes Futter beim Start
}


void ASnakeGrid::Tick(float DeltaTime)
{
    Super::Tick(DeltaTime);
}

FVector ASnakeGrid::GridToWorld(int32 X, int32 Y)
{
    // Berechnet die Welt-Position basierend auf der Zellengröße
    return GetActorLocation() + FVector(X * CellSize, Y * CellSize, 0.0f);
}

void ASnakeGrid::SpawnFood()
{
    // Verhindert Absturz, falls im Blueprint kein Food-Actor ausgewählt wurde
    if (!FoodClass) return; 

    int32 RandX = FMath::RandRange(0, GridSizeX - 1);
    int32 RandY = FMath::RandRange(0, GridSizeY - 1);
    FVector SpawnPos = GridToWorld(RandX, RandY);

    GetWorld()->SpawnActor<AActor>(FoodClass, SpawnPos, FRotator::ZeroRotator);
}