#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Pawn.h"
#include "SnakeGrid.h"
#include "FoodItem.h"
#include "Blueprint/UserWidget.h"
#include "PlayerSnake.generated.h"

UCLASS()
class SNAKE_API APlayerSnake : public APawn
{
    GENERATED_BODY()

public:
    APlayerSnake();

protected:
    virtual void BeginPlay() override;

public:    
    virtual void Tick(float DeltaTime) override;
    virtual void SetupPlayerInputComponent(class UInputComponent* PlayerInputComponent) override;

    void Move();
    void SpawnFood();
    void HandleGameOver();

    // Power-Up Resets
    void ResetSpeed();
    void ResetGhostMode();

    // HUD Funktionen (für WBP_SnakeHUD Bindings)
    UFUNCTION(BlueprintCallable, Category = "Snake HUD")
    int32 GetCurrentScore() const { return Score; }

    UFUNCTION(BlueprintCallable, Category = "Snake HUD")
    bool IsGhostModeActive() const { return bIsGhostMode; }

    // Input-Handler
    void MoveUp();
    void MoveDown();
    void MoveLeft();
    void MoveRight();

    UPROPERTY(EditAnywhere, Category = "Snake Settings")
    ASnakeGrid* GridReference;

    UPROPERTY(EditAnywhere, Category = "Snake Settings")
    TArray<TSubclassOf<AFoodItem>> FoodClasses;

    
    UPROPERTY(EditAnywhere, Category = "Snake UI")
    TSubclassOf<UUserWidget> GameOverWidgetClass;

    UPROPERTY(VisibleAnywhere, Category = "Snake Logic")
    TArray<FIntPoint> BodyPoints;

    UPROPERTY(EditAnywhere, Category = "Snake Settings")
    float DefaultMoveSpeed = 0.2f;

private:
    FIntPoint CurrentDirection;
    FTimerHandle MoveTimerHandle;
    FTimerHandle PowerUpTimerHandle;
    FTimerHandle GhostTimerHandle;
    
    bool bHasInputThisTick; 
    bool bIsGhostMode;
    float CurrentMoveSpeed;
    int32 Score;
};