#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "FoodItem.generated.h"

UENUM(BlueprintType)
enum class EFoodType : uint8
{
    Normal      UMETA(DisplayName = "Normal (Grow)"),
    SpeedUp     UMETA(DisplayName = "Speed Up (Temporary)"),
    SlowDown    UMETA(DisplayName = "Slow Down"),
    GhostMode   UMETA(DisplayName = "Ghost Mode (No Self-Collision)")
};

UCLASS()
class SNAKE_API AFoodItem : public AActor
{
    GENERATED_BODY()
    
public:    
    AFoodItem();

    UPROPERTY(VisibleAnywhere, Category = "Food")
    FIntPoint GridLocation;

    UPROPERTY(EditAnywhere, BlueprintReadWrite, Category = "Food")
    EFoodType FoodType;

    UPROPERTY(VisibleAnywhere, BlueprintReadWrite, Category = "Food")
    UStaticMeshComponent* MeshComponent;
};