// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "Obstacle.h"
#include "MoonFlower.generated.h"

/**
 * MoonFlower Obstacle
 * Special obstacle that can trigger a win condition
 */
UCLASS()
class LUMA2DSCROLLER_API AMoonFlower : public AObstacle
{
    GENERATED_BODY()

public:
    AMoonFlower();
    
    UPROPERTY(BlueprintReadOnly)
    bool won = false;

protected:
    virtual void OnPlayerEnter(class ALumaPaperCharacter* Player) override;

public:
    UFUNCTION(BlueprintCallable, Category="MoonFlower|Actions")
    void Win();
};
