// Fill out your copyright notice in the Description page of Project Settings.

#include "LightParticle.h"
#include "LumaPaperCharacter.h"

// Sets default values
ALightParticle::ALightParticle()
{
	// Default light amount
	EnergyAmount = 100;

	// Optional: smaller than a standard obstacle
	Width = 32.f;
	Height = 32.f;
}

void ALightParticle::OnPlayerEnter(ALumaPaperCharacter* Player)
{
    if(!Player) return;
    
    Player->ChangeEnergy(EnergyAmount);
    Destroy();
}
